﻿* Encoding: UTF-8.
* Encoding: .
*==============================================================================*.
* TÍTULO DE LA SINTAXIS:							   
* Cálculo de indicadores de la nueva condición de actividad		y sectorización de la PEA	   				   
* OPERACIÓN ESTADÍSTICA:													   
* Encuesta Nacional de Empleo, Desempleo y Subempleo (ENEMDU)				   
* UNIDAD TÉCNICA RESPONSABLE: 												   
* Dirección de Estadísticas Sociodemográficas (DIES)						   
* ENTIDAD EJECUTORA:														   
* Instituto Nacional de Estadística y Censos (INEC)							   
*==============================================================================*.
* Fecha de elaboración:          Septiembre - 2014							   
* Fecha última modificación:    Febrero - 2022				   
*==============================================================================*.
* Sintaxis elaborada en base a la "Nota metodológica para la medición del empleo en Ecuador".
*==============================================================================*.
* Elaborado por:													   
* Dirección de Estadísticas Sociodemográficas (DIES)						   
* Gestión de Estadísticas Permanentes a Hogares 	   						   
* Aprobado por:													   
* Dirección de Estudios Laborales y Económicos (DELE)				       
* Unidad de Estudios de Mercado Laboral								       
*==============================================================================*.
* Revisado por:																   
* 1. Dirección de Estudios Laborales y Económicos (DELE)				       
*    Unidad de Estudios de Mercado Laboral								       
* 2. Dirección de Estadísticas Sociodemográficas (DIES)						   
*    Gestión de Estadísticas Permanentes a Hogares 	   						   
*==============================================================================*.
*Indicaciones.
*1- Ejecute esta sintaxis en la base de datos: enemdu_persona_ xxxx_xx

*==============================================================================*.
*VARIABLES PARA DE TRABAJO PARA GENERACIÓN DE TABULADOS DE MERCADO LABORAL
*==============================================================================*.

*=============================================.
compute t=1.
var lab t 'Poblacion Total'.
*=============================================.
*Generación de Indicadores de Mercado Laboral - Tasas.
*=============================================.
if( petn=1) templeob=0.
if (empleo=1) templeob=1.
if (pean=1) templeog=0.
if (empleo=1) templeog=1.
if (pean=1) tadec=0.
if (adec=1) tadec=1.
if( pean=1) tsub=0.
if (sub=1) tsub=1.
if ( pean=1) toinad=0.
if (oinad=1) toinad=1.
if( pean=1) tnr=0.
if (nr=1) tnr=1.
if( pean=1) tdesem=0.
if (desem=1) tdesem=1.
if( t_a=1) tpartib15=0.
if (pean=1 and p03>=15) tpartib15=1.
if( petn=1) tpartig=0.
if (pean=1 and p03>=15) tpartig=1.
if(empleo=1) tinfo=0.
if (empleo=1 & informal=1) tinfo=1.
exe.

*=======================.
*Grupos étnicos
*=======================.
recode p15 (1=1) (2=2)(3=2)(4=2)(5=3) (6=4) (7=5) (8=6) into etnia.
val lab etnia 1"Indigena" 2"Afroecuatoriano" 3"Montubio" 4"Mestizo/a" 5"Blanco" 6"Otro Cual".
var lab etnia 'Etnia'.
recode etnia (6=sysmis).
var lev etnia (nominal).
exe.

*============================. 
*Estado Civil
*============================.
recode p06 (1=1)(2=4)(3=4)(4=4)(5=2)(6=3) into estciv.
val lab estciv 1"Casado" 2"Union libre" 3"Soltero" 4"Otro".
var lab estciv 'Estado Civil'.
exe.

*=======================.
*Grupos de edad-empleo
*=======================.
 if (p03 >= 15 & p03 <= 17) gedade=1.
 if (p03 >= 18 & p03 <= 29) gedade=2.
 if (p03 >= 30 & p03 <= 44) gedade=3.
 if (p03 >= 45 & p03 <= 64) gedade=4 .
 if (p03 >= 65) gedade=5.
exe.
var lab gedade 'Grupos de edad'.
val lab gedade 
1'15 a 17 años'
2'18 a 29 años'
3'30 a 44 años'
4'45 a 64 años'
5'65 años y más'.

*=========================.
*Filtros.
*=========================.
IF ((p02=1 or p02=2 ) ) fil00=1.
if p02=1   fil01=1.
if p02=2  fil02=1.
exe.
var lab fil00'Nacional'
/fil01'Hombre' 
/fil02'Mujer'.

*=========================.
*Región.
*=========================.
 if (prov= 1 | prov= 2 | prov= 3 | prov= 4 | prov= 5 | prov= 6 | prov= 10 | prov= 11 | prov= 17 | prov= 18  | prov=23)  rn = 1.
 if (prov= 7 | prov= 8 | prov= 9 | prov= 12 | prov= 13 |  prov = 90 | prov=24 )  rn = 2.
 if (prov= 14 | prov= 15 | prov= 16 | prov= 19 | prov= 21 | prov= 22  )  rn = 3.
 if (prov=20) rn = 4.
exe.
var lab rn 'Región'.
val lab rn 1'Sierra' 2'Costa' 3'Amazonía' 4'Insular'.
exe.

*=========================.
*Zonas de Planificación.
*=========================.
compute can=TRUNC(ciudad/100).
exe.
 if  (prov= 4 |  prov= 8 | prov= 10 | prov=21 | ciudad=900151) zdp = 1.
 if  (prov=15 | (prov=17 & can<>1701)| prov=22) zdp = 2.
 if  (prov= 5 |  prov= 6 | prov= 16 | prov=18) zdp = 3.
 if  (prov=13 |  prov=23) zdp = 4.
 if  (prov= 2 | (prov= 9 & can<> 0901 & can<>0907 & can<> 0916) | prov= 12 | prov= 20 | prov=24 | ciudad=900351 | ciudad=900451) zdp = 5.
 if  (prov= 1 |  prov= 3 | prov=14) zdp = 6.
 if  (prov= 7 |  prov=11 | prov=19) zdp = 7.
 if (can=0901 | can=0907 | can=0916) zdp = 8.
 if (can=1701) zdp = 9.
var lab zdp 'Zonas de Planificación'.
val lab zdp 
1 "Zona 1" 
2 "Zona 2" 
3 "Zona 3" 
4 "Zona 4"
5 "Zona 5" 
6 "Zona 6" 
7 "Zona 7" 
8 "Zona 8" 
9 "Zona 9".
exe.
*Etiquetas.
 * 1 "Zona 1: Carchi, Esmeraldas, Imbabura, Sucumbíos, Las Golondrinas" 
2 "Zona 2: Napo, Pichincha (excepto DMQuito), Orellana" 
3 "Zona 3: Cotopaxi, Chimborazo, Pastaza, Tungurahua" 
4 "Zona 4: Manabí, Santo Domingo"
5 "Zona 5: Bolivar, Guayas (excepto Guayaquil, San Borondon, Duran), Los Ríos, Galápagos, Santa Elena, Manga del Cura, El Piedrero" 
6 "Zona 6: Azuay, Cañar, Morona Santiago" 
7 "Zona 7: El Oro, Loja, Zamora Chinchipe" 
8 "Zona 8: Guayaquil, San Borondón, Durán" 
9 "Zona 9: DM Quito".
del var can.
*======================*.
*QUINTILES DE INGRESO
*======================*.
weight by fexp.
sort cases by ingpc(a).
rank variables=ingpc(a) /ntiles(5) into quintil /ties=low .
var lab quintil 'Quintil de ingreso'.
val lab quintil
1'Quintil 1'
2'Quintil 2'
3'Quintil 3'
4'Quintil 4'
5'Quintil 5'.

